<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8"%>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.Interaction" %>
<%@ page import="com.genesyslab.ail.exception.RequestFailedException" %>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <script language="javascript">
      window.parent.includeGDFunctionalities(window);

      function custom_load() {
        activateGDFunctionalities();
      }

      function custom_unload() {
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body height="0" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="custom_load()" onunload="custom_unload()">
    <script language="javascript">
<%
    /* Get data from request
     */
    String idInteraction = (String)request.getParameter( "idInteraction" );
    String[] codeIds = (String[])request.getParameterValues( "codeId" );
    String[] codeChecked = (String[])request.getParameterValues( "codeChecked" );

    /* Initialize AIL related data
     */
    AilFactory factory = AilLoader.getAilFactory();
    Interaction interaction = factory.getInteraction( idInteraction );

    /* Apply disposition code in interaction
       Here set attached data
       This part can be changed to store the disposition on another container
       as a file, a database...
     */
    try {
        interaction.removeAttachedData("DispositionCode");
        for (int i=0;i<codeIds.length;i++) {
            if ("true".equals(codeChecked[i])) {
                interaction.setAttachedData("DispositionCode",codeIds[i]);
                break;
            }
        }

        interaction.saveAttachedData();
%>
      showInformationMessage("Disposition codes successfully applied!");
<%
    } catch( RequestFailedException requestFailedException ) {
        System.out.println("Attached data update failed: "+requestFailedException);
%>
      showWarningMessage("Apply Disposition codes failed updating Attached data!");
<%
    }
%>
    </script>
  </body>
</html>
